import pygame

from OpenGL.GL import *
from OpenGL.GLU import *

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 6 - Texture Mapping"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    #instance variables to be replaced with objects
    self.rot = [0,0,0]
  def initGL(self):
    if not self.texloaded: self.loadGLTextures()
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    #self.glinited = True
  def loadGLTextures(self):
    self.textures.append(pygame.image.load("Data/NeHe.bmp"))
    self.tnames = glGenTextures(1)
    if not hasattr(self.tnames,"__len__"):
      self.tnames = (self.tnames,)
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    idat = pygame.image.tostring(self.textures[0],"RGB",True)
    glTexImage2D(GL_TEXTURE_2D,0,3,self.textures[0].get_width(),self.textures[0].get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    #self.textures[0] = None
    #self.texloaded = True
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    glTranslatef(0,0,-5)
    glRotatef(self.rot[0],1,0,0)
    glRotatef(self.rot[1],0,1,0)
    glRotatef(self.rot[2],0,0,2)
    #select texture
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glBegin(GL_QUADS)
    #front
    glTexCoord2f(0,0);glVertex3f(-1,-1,1)
    glTexCoord2f(1,0);glVertex3f(1,-1,1)
    glTexCoord2f(1,1);glVertex3f(1,1,1)
    glTexCoord2f(0,1);glVertex3f(-1,1,1)
    #back
    glTexCoord2f(0,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(-1,1,-1)
    glTexCoord2f(0,1);glVertex3f(1,1,-1)
    #left
    glTexCoord2f(0,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(-1,-1,1)
    glTexCoord2f(1,1);glVertex3f(-1,1,1)
    glTexCoord2f(0,1);glVertex3f(-1,1,-1)
    #right
    glTexCoord2f(0,0);glVertex3f(1,-1,1)
    glTexCoord2f(1,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(1,1,-1)
    glTexCoord2f(0,1);glVertex3f(1,1,1)
    #top
    glTexCoord2f(0,0);glVertex3f(-1,1,1)
    glTexCoord2f(1,0);glVertex3f(1,1,1)
    glTexCoord2f(1,1);glVertex3f(1,1,-1)
    glTexCoord2f(0,1);glVertex3f(-1,1,-1)
    #bottom
    glTexCoord2f(0,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(1,-1,1)
    glTexCoord2f(0,1);glVertex3f(-1,-1,1)
    glEnd()
    self.rot[0]+=.1
    self.rot[1]+=.05
    self.rot[2]+=.005

screen = Screen()
screen.resize()

running = 1
while running:
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
        
